/***************************************************************************
 *
 * Copyright (C) 2001 International Business Machines
 * All rights reserved.
 *
 * This file is part of the GPFS mmfslinux kernel module.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice, 
 *     this list of conditions and the following disclaimer. 
 *  2. Redistributions in binary form must reproduce the above copyright 
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution. 
 *  3. The name of the author may not be used to endorse or promote products 
 *     derived from this software without specific prior written
 *     permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *************************************************************************** */
/* @(#)77	1.7  src/avs/fs/mmfs/ts/kernext/ibm-linux/cxiMode-plat.h, mmfs, avs_remp, rempt1d1 9/22/01 22:38:35 */

#ifndef _h_cxiMode_plat
#define _h_cxiMode_plat

/* Linux portability portion of GPFS will have to include its own version of 
 * these linux header files before inclusion of cxiMode.h
 */
#ifndef GPFS_GPL
#include <fcntl.h>
#include <sys/stat.h>
#endif

/* These came from aix <sys/mode.h> and currently have equivalent 
 * definitions in linux <sys/stat.h>.  
 */
#ifndef S_IFMT
#define S_IFMT          0170000 /* type of file */
#define   S_IFREG       0100000 /*   regular */
#define   S_IFDIR       0040000 /*   directory */
#define   S_IFBLK       0060000 /*   block special */
#define   S_IFCHR       0020000 /*   character special */
#define   S_IFIFO       0010000 /*   fifo */
#define   S_IFLNK       0120000 /*   symbolic link */
#define   S_IFSOCK      0140000 /*   socket */

#define S_ISUID	        0004000 /* set user id on execution */
#define S_ISGID	        0002000 /* set group id on execution */
#define S_ISVTX         0001000 /* save text */

                                /* ->>> /usr/group definitions <<<- */
#define S_IRWXU	        0000700 /* read,write,execute perm: owner */
#define S_IRUSR	        0000400 /* read permission: owner */
#define S_IWUSR	        0000200 /* write permission: owner */
#define S_IXUSR	        0000100 /* execute/search permission: owner */
#define S_IRWXG	        0000070 /* read,write,execute perm: group */
#define S_IRGRP	        0000040 /* read permission: group */
#define S_IWGRP         0000020 /* write permission: group */
#define S_IXGRP	        0000010 /* execute/search permission: group */
#define S_IRWXO	        0000007 /* read,write,execute perm: other */
#define S_IROTH         0000004 /* read permission: other */
#define S_IWOTH	        0000002 /* write permission: other */
#define S_IXOTH	        0000001 /* execute/search permission: other */
#endif /* S_IFMT */

/* This mode bit is needed for compatibility with the JFS ACL API 
   and has no effect on Shark file system operations.*/
#define S_IXACL      0x02000000 /* extended ACL */


/* gpfsAccess() mode parameter */
#define	E_ACC                00 /* E_ACC does file exist */
#define	X_ACC           S_IXOTH	/* X_ACC is it executable by caller */
#define	W_ACC           S_IWOTH	/* W_ACC writable by caller */
#define	R_ACC           S_IROTH	/* R_ACC readable by caller */

/* File type macros */
#ifndef S_ISFIFO
#define S_ISFIFO(m)     (((m)&(S_IFMT)) == (S_IFIFO))
#define S_ISDIR(m)      (((m)&(S_IFMT)) == (S_IFDIR))
#define S_ISCHR(m)      (((m)&(S_IFMT)) == (S_IFCHR))
#define S_ISBLK(m)      (((m)&(S_IFMT)) == (S_IFBLK))
#define S_ISREG(m)      (((m)&(S_IFMT)) == (S_IFREG))
#define S_ISLNK(m)      (((m)&(S_IFMT)) == (S_IFLNK))
#define S_ISSOCK(m)     (((m)&(S_IFMT)) == (S_IFSOCK))
#endif

#ifndef O_DIRECT
# define O_DIRECT	 040000	/* Direct disk access.  */
#endif

#define FOPEN          (-1)
#define FWRITE         (O_WRONLY-FOPEN)
#define FREAD          (O_RDONLY-FOPEN)
#define FNDELAY        O_NDELAY
#define FTRUNC         O_TRUNC
#define FCREAT         O_CREAT
#define FEXCL          O_EXCL
#define FAPPEND        O_APPEND
#define FSYNC          O_SYNC
#define O_DSYNC        O_SYNC
#define FDIRECT        O_DIRECT

/* Translate open flags in linux filp->f_flag to appropriate
 * flag for gpfs.  Since O_RDONLY is zero, this part of the
 * test must appear after the others and not be a bit 
 * comparison operator.
 */
#define cxiOpenFlagsXlate(flags)                  \
          (((flags) & ~O_ACCMODE) |                \
           (((flags) & O_RDWR) ? (FREAD | FWRITE) : \
            (((flags) & O_WRONLY) ? FWRITE :         \
             ((((flags) & O_ACCMODE) == O_RDONLY) ? FREAD : 0))))

#define ACL_MODE (S_ISUID|S_ISGID|S_ISVTX)

#define FFILESYNC FSYNC      /* another name for FSYNC (AIX fattr.h) */
#define FDATASYNC 0x00400000 /* fsync data only (AIX fattr.h)        */

/* gpfsSetattr() flags (originally from aix sys/chownx.h)
 * Specifies how the uid and gid values are to be set.
 */
#define	T_OWNER_AS_IS 004 /* the owner id in the inode is unaltered */
#define	T_GROUP_AS_IS 040 /* the group id in the inode is unaltered */
#define	T_SYNC_IF_NFS 400 /* might need to sync chown for nfs */

#ifndef SEEK_SET
#define SEEK_SET 0
#endif
#ifndef SEEK_CUR
#define SEEK_CUR 1
#endif
#ifndef SEEK_END
#define SEEK_END 2
#endif

/* gpfsAccess() who parameter */
#define ACC_SELF        0x00
#define ACC_OTHERS      0x08
#define ACC_ANY	        0x10
#define ACC_ALL	        0x20

#endif /* _h_cxiMode-plat */
